package gov.va.med.mhv.admin.repository;

import gov.va.med.mhv.common.data.model.Patient;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PatientRepository extends JpaRepository<Patient, Long> {

	@Query("select patient from Patient patient where patient.userProfileId = :userProfileid")
	public List<Patient> getPatientByUserProfileId(@Param("userProfileid") Long userProfileid);

	@Query("select patient from Patient patient where patient.icn = :icn")
	public List<Patient> getPatientByIcn(@Param("icn") String icn);

	@Query("select patient from Patient patient where lower(patient.icn) like lower(:icn)")
	public List<Patient> getPatientByPartialIcn(@Param("icn") String icn);

	@Query("select patient from Patient patient where patient.icn = :icn")
	public Patient getPatientByInvalidatedIcn(@Param("icn") String icn);

	@Query("select p from Patient p, UserProfile u " + "where u.lastName not like 'DELETED' "
			+ "and u.lastName not like 'DECEASED' " + "and p.matchedDateTime is not null "
			+ "and (p.correlationStatus = 0 or p.correlationStatus = 7)")
	public List<Patient> getMatchedUncorrelatedPatients();

	@Query("select p from Patient p, UserProfile u " + "where ((u.firstName is null " + "or u.lastName is null "
			+ "or u.birthDate is null " + "or u.ssn is null " + "or u.gender is null) or " + "(u.firstName ='' "
			+ "or u.lastName ='' " + "or u.birthDate ='' " + "or u.ssn ='' " + "or u.gender = '')) "
			+ "and u.addressCountry is not null " + "and u.addressCountry != 'Korea, South' "
			+ "and u.addressCountry != 'Virgin Islands, British' " + "and u.lastName not like '%DELETED' "
			+ "and u.lastName not like '%Deleted' " + "and u.lastName not like '%DECEASED' "
			+ "and u.lastName not like '%Deceased' " + "and p.userProfileId = u.id")
	public List<Patient> getRequiredFieldsNotEmpty();

	@Query("select p from Patient p, UserProfile u " + "where (u.firstName is not null " + "or u.lastName is not null "
			+ "or u.birthDate is not null " + "or u.ssn is not null " + "or u.gender is not null) "
			+ "and (u.isVeteran = 1 or u.isPatient = 1) " + "and u.addressCountry is not null "
			+ "and u.addressCountry != 'Korea, South' " + "and u.addressCountry != 'Virgin Islands, British' "
			+ "and p.matchedDateTime is null " + "and u.lastName not like '%DELETED' "
			+ "and u.lastName not like '%Deleted' " + "and u.lastName not like '%DECEASED' "
			+ "and u.lastName not like '%Deceased' " + "and u.id between :firstRow and :lastRow "
			+ "and p.userProfileId = u.id")
	public List<Patient> getRecordsNotMatchedToMVI(@Param("firstRow") long firstRow, @Param("lastRow") long lastRow);

	@Query("select p from Patient p, UserProfile u where  " + "p.icn is not null " + "and u.addressCountry is not null "
			+ "and u.addressCountry != 'Korea, South' " + "and u.addressCountry != 'Virgin Islands, British' "
			+ "and u.id between :firstRow and :lastRow " + "and u.lastName not like '%DELETED' "
			+ "and u.lastName not like '%Deleted' " + "and u.lastName not like '%DECEASED' "
			+ "and u.lastName not like '%Deceased' " + "and (u.isVeteran = 1 or u.isPatient = 1)")
	public List<Patient> getRecordsMHVMVIMisMatch(@Param("firstRow") long firstRow, @Param("lastRow") long lastRow);

	@Query("select p from Patient p, UserProfile u where " + "p.icn is not null "
			+ "and (u.createdDate < :createdDate or u.lastLogin < :createdDate) " + "and p.icn like '%A%' "
			+ "and (u.createdDate is not null or u.lastLogin is not null) " + "and u.contactInfoEmail is not null "
			+ "and (u.createdDate < :createdDate or u.lastLogin < :createdDate) "
			+ "and u.lastName not like '%DECEASED' " + "and u.lastName not like '%Deceased' "
			+ "and p.userProfileId = u.id")
	public List<Patient> getAutoDeactivationList(@Param("createdDate") Date createdDate);
}
